<?php

class RenderLogo
{
    private $Size = 120;

    private function Color($Mark)
    {
        if (substr_count($Mark, 0) >= 1) {
            return "#FFFFFF";
        }
        if (substr_count($Mark, 1) >= 1) {
            return "#000000";
        }
        if (substr_count($Mark, 2) >= 1) {
            return "#8C8A8D";
        }
        if (substr_count($Mark, 3) >= 1) {
            return "#FFFFFF";
        }
        if (substr_count($Mark, 4) >= 1) {
            return "#FE0000";
        }
        if (substr_count($Mark, 5) >= 1) {
            return "#FF8A00";
        }
        if (substr_count($Mark, 6) >= 1) {
            return "#FFFF00";
        }
        if (substr_count($Mark, 7) >= 1) {
            return "#8CFF01";
        }
        if (substr_count($Mark, 8) >= 1) {
            return "#00FF00";
        }
        if (substr_count($Mark, 9) >= 1) {
            return "#01FF8D";
        }
        if (substr_count($Mark, "A") >= 1) {
            return "#00FFFF";
        }
        if (substr_count($Mark, "B") >= 1) {
            return "#008AFF";
        }
        if (substr_count($Mark, "C") >= 1) {
            return "#0000FE";
        }
        if (substr_count($Mark, "D") >= 1) {
            return "#8C00FF";
        }
        if (substr_count($Mark, "E") >= 1) {
            return "#FF00FE";
        }
        if (substr_count($Mark, "F") >= 1) {
            return "#FF008C";
        }
    }
    private function LoadLogo($Image, $Hexcode, $Height = 0, $Width = 0)
    {
        $Pixel = $this->Size / 8;

        for ($WLogo = 0; $WLogo < 8; $WLogo++) {
            for ($HLogo = 0; $HLogo < 8; $HLogo++) {
                $SetLogo = ($WLogo * 8) + $HLogo;
                $Define[$WLogo][$HLogo] = substr($Hexcode, $SetLogo, 1);
            }
        }
        for ($WLogo = 1; $WLogo <= 8; $WLogo++) {
            for ($HLogo = 1; $HLogo <= 8; $HLogo++) {
                $Send = $Define[$WLogo - 1][$HLogo - 1];
                for ($Repeat = 0; $Repeat < $Pixel; $Repeat++) {
                    for ($Repeated = 0; $Repeated < $Pixel; $Repeated++) {
                        $LoadY = ((($WLogo - 1) * $Pixel) + $Repeat);
                        $LoadX = ((($HLogo - 1) * $Pixel) + $Repeated);
                        $Defined[$LoadY][$LoadX] = $Send;
                    }
                }
            }
        }
        for ($WLogo = 0; $WLogo < $this->Size; $WLogo++) {
            for ($HLogo = 0; $HLogo < $this->Size; $HLogo++) {
                $Send = strtoupper($Defined[$WLogo][$HLogo]);
                $Color = substr($this->Color($Send), 1);
                $Gerate[0] = substr($Color, 0, 2);
                $Gerate[1] = substr($Color, 2, 2);
                $Gerate[2] = substr($Color, 4, 2);
                $Img = imagecreate(1, 1);
                $Finish = imagecolorallocatealpha($Img, hexdec($Gerate[0]), hexdec($Gerate[1]), hexdec($Gerate[2]), 0);
                imagefilledrectangle($Img, 0, 0, 1, 1, $Finish);
                imagecopy($Image, $Img, $Height + $HLogo, $Width + $WLogo, 0, 0, 1, 1);
                imagedestroy($Img);
            }
        }

        header("Content-type: image/png");
        imagepng($Image);
    }
    public function ViewLogo()
    {
        $this->Size = 120;
        $this->LoadLogo(imagecreate($this->Size, $this->Size), $_GET["render"]);
        if (empty($_GET["render"])) {
            die("Not Generate Guild Logo");
        }
    }
}

$logo = new RenderLogo();
$logo->ViewLogo();
