<?php

namespace Amwdeveloper\view;

use Amwdeveloper\controller\user as controlleruser;
use Amwdeveloper\core\session;
use League\Plates\Engine;
use voku\helper\HtmlMin;

class user extends controlleruser
{

    private $route;
    private $view;
    private $title;

    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../theme/" . config['path'] . "/pages", 'phtml');
        $this->route = $route;
        $this->title = config['web_title'];
        $session = new session();

        if (!$session->has("useraccount")) {
            return $this->route->redirect("/");
        }
    }

    public function index()
    {
        echo $this->view->render('user/information', [
            'title' =>  $this->title . ' - Informações da conta'
        ]);
    }

    public function manageemail()
    {
        echo $this->view->render('user/email', [
            'title' =>  $this->title . ' - Atualizar E-mail'
        ]);
    }

    public function managepasswd()
    {
        echo $this->view->render('user/passwd', [
            'title' =>  $this->title . ' - Manage Password'
        ]);
    }

    public function managepersonalid()
    {
        echo $this->view->render('user/personalid', [
            'title' =>  $this->title . ' - Atualizar Personal ID'
        ]);
    }

    public function exchangecoins()
    {
        echo $this->view->render('user/exchangecoins', [
            'title' =>  $this->title . ' - Trocar moedas'
        ]);
    }

    public function logoutaccount()
    {
        $session = new session();
        $session->unset("useraccount");
        $this->route->redirect("/");
    }


    /** Character */
    public function characters()
    {
        echo $this->view->render('user/character/characters', [
            'title' =>  $this->title . ' - Personagens',
            'characters' => $this->mycharacters() ?? null
        ]);
    }

    public function managecharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/managecharacter', [
            'title' =>  $this->title . ' - Gerenciando personagem ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'route' => 'character'
        ]);
    }

    public function managenickcharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/managenickcharacter', [
            'title' =>  $this->title . ' - Alterar nick personagem ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'active' => previlegy_character['manage_nick']['active'],
            'route' => 'nick'
        ]);
    }

    public function manageclasscharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/manageclasscharacter', [
            'title' =>  $this->title . ' - Alterar classe personagem ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'active' => previlegy_character['manage_class']['active'],
            'route' => 'class'
        ]);
    }

    public function managemovecharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/managemovecharacter', [
            'title' =>  $this->title . ' - Alterar move personagem ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'active' => previlegy_character['manage_move']['active'],
            'route' => 'move'
        ]);
    }


    public function manageavatarcharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/manageavatarcharacter', [
            'title' =>  $this->title . ' - Alterar avatar personagem ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'active' => previlegy_character['manage_avatar']['active'],
            'route' => 'avatar'
        ]);
    }

    public function managerpowercharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/managerpowercharacter', [
            'title' =>  $this->title . ' - Comprar fire slash - ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'active' => previlegy_character['manage_avatar']['active']
        ]);
    }

    public function manageblockprofilecharacter($request)
    {
        $profile = $this->profilecharacter($request);

        echo $this->view->render('user/character/managerblockprofilecharacter', [
            'title' =>  $this->title . ' - Bloquear Perfil - ' . $request['char'],
            'characters' => $this->mycharacters() ?? null,
            'character' => $profile,
            'active' => previlegy_character['manage_bloc_profile']['active'],
            'route' => 'bloc_profile'
        ]);
    }

    /** Error */
    public function error($request)
    {
        var_dump($request);
    }
}
