<?php

namespace Amwdeveloper\view;

use Amwdeveloper\controller\admin as controlleradmin;
use Amwdeveloper\core\session;
use League\Plates\Engine;

class admin extends controlleradmin
{

    private $route;
    private $view;

    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../theme/admin/pages", 'phtml');
        $this->route = $route;
    }

    public function checklogin()
    {
        $session = new session();
        if (!$session->has("adminlogged")) {
            return $this->route->redirect("/administration/account/login");
        }
    }

    public function accountlogin()
    {
        $session = new session();
        if ($session->has("adminlogged")) {
            return $this->route->redirect("/administration/home");
        }
        echo $this->view->render('login');
    }


    public function index()
    {
        $this->checklogin();
        echo $this->view->render('home', [
            'title' =>  'Informações',
            'amount' => $this->home()
        ]);
    }

    /** Post(Notice)*/
    public function newpost()
    {
        $this->checklogin();
        echo $this->view->render('post/newpost', [
            'title' =>  'Nova notícia'
        ]);
    }

    public function manageallposts()
    {
        $this->checklogin();
        echo $this->view->render('post/manageallposts', [
            'title' =>  'Gerenciar todas as notícias',
            'notices' => $this->allnotice() ?? null
        ]);
    }

    public function toeditpost($request)
    {
        $this->checklogin();
        $notice = $this->loadinfopost($request);

        echo $this->view->render('post/toeditpost', [
            'title' =>  'Editar notícia',
            'notice' => $notice
        ]);
    }

    /** Donwload */
    public function newdownload()
    {
        $this->checklogin();
        echo $this->view->render('download/newdownload', [
            'title' =>  'Novo download'
        ]);
    }

    public function managealldownloads()
    {
        $this->checklogin();
        echo $this->view->render('download/managealldownloads', [
            'title' =>  'Gerenciar todos os downloads',
            'downloads' => $this->alldownloads() ?? null
        ]);
    }

    public function toeditdownload($request)
    {
        $this->checklogin();
        $download = $this->loadinfodownload($request);

        echo $this->view->render('download/toeditdownload', [
            'title' =>  'Editar download',
            'download' => $download
        ]);
    }

    /** Account Manage */
    public function accountaddcoin()
    {
        $this->checklogin();
        echo $this->view->render('account/addcoin', [
            'title' =>  'Adicionar moeda',
            'coins' => coins
        ]);
    }

    public function accountremovecoin()
    {
        $this->checklogin();
        echo $this->view->render('account/removecoin', [
            'title' =>  'Remover moeda',
            'coins' => coins
        ]);
    }

    public function accountaddvip()
    {
        $this->checklogin();
        echo $this->view->render('account/addvip', [
            'title' =>  'Adicionar vip',
            'vips' => vip
        ]);
    }

    public function accountremovevip()
    {
        $this->checklogin();
        echo $this->view->render('account/removevip', [
            'title' =>  'Remover vip'
        ]);
    }

    public function accountbanunban()
    {
        $this->checklogin();
        echo $this->view->render('account/banunban', [
            'title' =>  'Banir / Desbanir conta'
        ]);
    }

    public function accountdetails($request)
    {
        $account = filter_var($request['account'], FILTER_SANITIZE_SPECIAL_CHARS);
        
        if (!$account)  return $this->route->redirect("/administration/account/login");

        $characters = $this->informationaccountsearch($account);

        echo $this->view->render('account/details', [
            'title' =>  'Informações da conta - ' . $account,
            'information' => $characters
        ]);
    }

    public function accountbalance()
    {
        echo $this->view->render('account/balances', [
            'title' =>  'Movimentações de Saldos',
            'balances' => $this->table('amw_balance_logs')->orderby('id', 'DESC')->all()
        ]);
    }

    /** Character Manage */
    public function characteraddstaff()
    {
        $this->checklogin();
        echo $this->view->render('character/addstaff', [
            'title' =>  'Adicionar a staff'
        ]);
    }

    public function characterbanunban()
    {
        $this->checklogin();
        echo $this->view->render('character/banunban', [
            'title' =>  'Banir / Desbanir character'
        ]);
    }

    public function charactersall()
    {
        $this->checklogin();

        $characters = $this->table("Character")->columns('Name as name,AccountID as account,CtlCode as code')->all();
        echo $this->view->render('character/characters', [
            'title' =>  'Editar personagem',
            'characters' => $characters
        ]);
    }

    public function characteredit($character)
    {
        $this->checklogin();
        $char = filter_var($character['char'], FILTER_SANITIZE_SPECIAL_CHARS);
        $character = $this->table("Character")->columns('Name as name,Strength as strength,Dexterity as dexterity,Energy as energy,Vitality as vitality,' . columns_score_perfil['resets'] . ' as resets,' . columns_score_perfil['mresets'] . ' as mresets,' . columns_score_perfil['killer'] . ' as kills,' . columns_score_perfil['hero'] . ' as hero, Class as class, Leadership as command,cLevel as level')->where('Name = :name', "name={$char}")->get();

        if (!$character) return $this->route->redirect('/administration/character/all/characters');

        echo $this->view->render('character/edit', [
            'title' =>  'Editar personagem - ' . $character->name,
            'character' => $character
        ]);
    }


    /** Slider */

    public function slideraddnew()
    {
        $this->checklogin();
        echo $this->view->render('slider/addslider', [
            'title' =>  'Adicionar nova slider'
        ]);
    }

    public function sliderall()
    {
        $this->checklogin();
        echo $this->view->render('slider/allslider', [
            'title' =>  'Todas as slider',
            'sliders' => $this->allslider()
        ]);
    }

    public function toremoveslider($request)
    {
        $this->checklogin();
        $this->sliderremove($request);
    }

    public function accountlogout()
    {
        $session = new session();
        $session->unset('adminlogged');
        return $this->route->redirect("/administration/account/login");
    }


    public function templates()
    {
        $this->checklogin();

        $templates = $this->getTemplate();

        echo $this->view->render('settings/templates', [
            'title' =>  'Templates',
            'templates' => $templates
        ]);
    }

    /** Error */
    public function error($request)
    {
        var_dump($request);
    }
}
