<?php

function plugin(): object
{
    foreach (plugin as $key => $p) {
        $plugins[$key] = $p;
    }

    return (object) $plugins;
}

function server(): object
{
    foreach (server as $key => $value) {
        $serverinfo[$key] = $value;
    }
    return (object)$serverinfo;
}

function web(): object
{
    return (object)[
        'logo' => __files('images/logo.png'),
        'status' => config['status_server'],
        'players_online' => (new \Amwdeveloper\core\geral())->playersonline(),
        'acountscreate' => (new \Amwdeveloper\core\geral())->accounts(),
        'accountsvip' => (new \Amwdeveloper\core\geral())->accountsVip(),
        'accountsbanned' => (new \Amwdeveloper\core\geral())->accountsBanned(),
        'ranking_home' => ranking_home['type'],
        'ranking_home_events' => ranking_home_events['type'],
        'ranking_geral_links' => ranking_geral['rankings'],
        'ranking_geral_type' => ranking_geral['type'],
        'banks' => banks,
        'shoppings' => web_shopping['shopping_category'],
        'shopping_groups' => group_items,
        'shoppings_kit' => web_shopping['shopping_category'],
    ];
}

function accountuser(): array
{
    return (new \Amwdeveloper\controller\user())->myaccount();
}

function web_files(string $type): ?string
{
    if ($type == 'css') {
        return '
        <link rel="stylesheet" href="' . __resources('assets/css/mini.css') . '">
        <link rel="stylesheet" href="' . __resources('assets/css/slider.css') . '">
        <script src="' . __resources('assets/js/script.js') . '"></script>
    ';
    }

    if ($type == 'js') {
        return '
        <script src="' . __resources('assets/js/jquery.js') . '"></script>
        <script src="' . __resources('assets/js/slider.js') . '"></script>
        <script src="' . __resources('assets/js/web.js') . '"></script>
    ';
    }
    return null;
}
function web_files_adm(string $type): ?string
{
    if ($type == 'css') {
        return '
        <link rel="stylesheet" href="' . __resources('assets/css/mini.css') . '">
        <link rel="stylesheet" href="' . __resources('assets/css/slider.css') . '">
    ';
    }

    if ($type == 'js') {
        return '
        <script src="' . __resources('assets/js/slider.js') . '"></script>
        <script src="' . __resources('assets/js/web.js') . '"></script>
    ';
    }
    return null;
}
