<?php

function __files(string $file): string
{
    return base_url . 'theme/' . config['path'] . '/assets/' . $file;
}

function __filesadm(string $file): string
{
    return base_url . 'theme/admin/assets/' . $file;
}

function __resources(string $file): string
{
    return base_url . 'resource/' . $file;
}

function __redirect($url = '')
{
    return $url ? base_url . $url : base_url;
}

function __seo()
{
    return '<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="author" content="André - amwdeveloper.com.br">
    <meta name="description" content="' . server['name'] . ',MuOnline,Mu,MMORPG,Jogo Gratis,Mundo Aberto,Online,Server">
    <meta name="keywords" content="' . server['name'] . ',MuOnline,Mu,MMORPG,Jogo Gratis,Mundo Aberto,Online,Server">
    <meta name="robots" content="index/follow">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:author" content="André - amwdeveloper.com">
    <meta property="og:url" content="' . base_url . '">
    <meta property="og:keywords" content="' . server['name'] . ',MuOnline,Mu,MMORPG,Jogo Gratis,Mundo Aberto,Online,Server" />
    <meta property="og:robots" content="index/follow" />
    <meta property="og:title" content="' . server['name'] . '" />
    <meta property="og:description" content="' . server['name'] . ',MuOnline,Mu,MMORPG,Jogo Gratis,Mundo Aberto,Online,Server">';
}

function __avatar(?string $imagem): string
{
    return (!empty($imagem)) ? __resources("avatar/{$imagem}") : __resources("avatar/no-avatar.png");
}

function __guildmark($mark): ?string
{
    return $mark != null ? base_url . 'resource/mark/guild.php?render=' . bin2hex($mark) : null;
}

function __staffs()
{
    return (new \Amwdeveloper\core\geral())->staffs();
}

function __updatedate($date, $days)
{
    return date('Y-m-d H:i:s', strtotime("+{$days} days", strtotime($date)));
}

function __csrf()
{
    $session = (new \Amwdeveloper\core\session());
    if (!$session->has('token_csrf')) {
        $csrf = $session->set('token_csrf', md5(uniqid()));
    } else {
        $session->unset('token_csrf');
        $csrf =  $session->set('token_csrf', md5(uniqid()));
    }

    return "<input type=\"hidden\" name=\"token_form\" value=\"{$csrf->token_csrf}\">";
}

function __login(): bool
{
    $session = (new \Amwdeveloper\core\session());
    if (!$session->has("useraccount")) {
        return false;
    }
    return true;
}


function requests_form(string $key, int $limit = 5, int $time = 1)
{
    $session = (new \Amwdeveloper\core\session());

    if ($session->has($key) && $session->$key->request >= $limit) {
        $session->set($key, [
            'block' => date('Y-m-d H:i:s', strtotime("+{$time} minutes", strtotime("now"))),
            'request' => 1
        ]);
        return true;
    }

    if ($session->has($key) && $session->$key->block >= date('Y-m-d H:i:s', strtotime("now"))) {
        return true;
    }

    if ($session->has($key) && $session->$key->request < $limit) {
        $session->set($key, [
            'block' => null,
            'request' => $session->$key->request + 1
        ]);
        return false;
    }

    $session->set($key, [
        'block' => null,
        'request' => 1
    ]);

    return false;
}

function amwdeveloper()
{
    return new \Amwdeveloper\model\layer;
}

function dateBRL($date)
{
    $h = date('H:i', strtotime($date));
    $d = date('d', strtotime($date));
    $m = date('M', strtotime($date));
    $month = ['Jan' => 'Janeiro', 'Feb' => 'Fevereiro', 'Mar' => 'Marco', 'Apr' => 'Abril', 'May' => 'Maio', 'Jun' => 'Junho', 'Jul' => 'Julho', 'Aug' => 'Agosto', 'Nov' => 'Novembro', 'Sep' => 'Setembro', 'Oct' => 'Outubro', 'Dec' => 'Dezembro'];
    return "{$d} de {$month[$m]} - {$h}";
}
