<?php

namespace Amwdeveloper\plugins\webshop;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;

class item extends layer
{

    public $infoitem;
    public $excelents;
    public $ancient;
    public $idx;


    public function setid($id = null)
    {
        $this->idx = $id;
        return $this;
    }

    public function info()
    {
        $itemverify = $this->table("amw_items")->where("id = :id", "id={$this->idx}")->get();
        if (empty($itemverify)) return null;

        $this->infoitem = $itemverify;

        if (web_shopping['db_version'] == 1) {
            $item_convert = $itemverify->id_item + ($itemverify->section  * 32);
            $item = (int)($item_convert % 256);
            $group = (int)($item_convert / 256);

            if ($group == 1) $this->excelents = 128;
        } else {
            $item = $itemverify->id_item;
        }

        $serial = str_pad(dechex(substr(rand(0, 9999999999), 0, 8)), 8, 0, STR_PAD_LEFT);
        return ['item' => $item, 'group' => $group ?? null, 'serial' => $serial, 'data' => $itemverify];
    }

    public function geratehex($table, $column, $coin, $price, $details)
    {



        $item = $this->info()['item'];
        $serial = $this->info()['serial'];
        $category = dechex($this->infoitem->section);


        /** [Level do item * 8] */
        $this->levelitem = $details['level'] * 8;

        /** [Validando os Adicionais dos itens e somando ao level do item] */
        if ($this->infoitem->aditional == 4 or $this->infoitem->aditional  == 20) $this->levelitem += 1;
        if ($this->infoitem->aditional == 8 or $this->infoitem->aditional  == 24) $this->levelitem += 2;
        if ($this->infoitem->aditional == 12 or $this->infoitem->aditional == 28) $this->levelitem += 3;

        /** [Se o Adicionar for >= 16 então o excelentes recebe + 64] */
        if ($this->infoitem->aditional >= 16) $this->excelents += 64;

        /** [Se existe Luck level recebe + 4 | se existe skill level recebe + 128] */
        if (isset($details['luck'])) $this->levelitem += 4;
        if (isset($details['skill'])) $this->levelitem += 128;


        /** [Validando os excelentes do item] */
        if (isset($details['excelent_1'])) $this->excelents +=  1;
        if (isset($details['excelent_2'])) $this->excelents +=  2;
        if (isset($details['excelent_3'])) $this->excelents +=  4;
        if (isset($details['excelent_4'])) $this->excelents +=  8;
        if (isset($details['excelent_5'])) $this->excelents += 16;
        if (isset($details['excelent_6'])) $this->excelents += 32;

        /** [Ancients do item] */
        if (isset($details['ancient'])) {
            if ($this->infoitem->ancient_1 == 1) $this->ancient = 5;
            elseif ($this->infoitem->ancient_2 == 1) $this->ancient = 10;
            else $this->ancient = 0;
        };


        $item_380 = isset($details['item_380']) ? 8 : 0;

        $hexaitem = str_pad(dechex($item), 2, 0, STR_PAD_LEFT);
        /** [Hex Durabilidade] */
        $durability = str_pad(dechex($this->infoitem->durability), 2, 0, STR_PAD_LEFT);
        /** [Hex Excelentes do Item] */
        $excelents  = str_pad(dechex($this->excelents), 2, 0, STR_PAD_LEFT);

        /** [Hex Level do item + Adicionais] */
        $levelitem  = str_pad(dechex($this->levelitem), 2, 0, STR_PAD_LEFT);

        /**[Hex Level do Ancient] */
        $ancient    = str_pad(dechex($this->ancient ?? 0), 2, 0, STR_PAD_LEFT);



        $harmony    = str_pad(dechex(isset($details['harmony']) ? $details['harmony'] : 0), 2, 0, STR_PAD_LEFT);

        $socket1    = str_pad(dechex(isset($details['socket1']) ? $details['socket1'] : 255), 2, 0, STR_PAD_LEFT);
        $socket2    = str_pad(dechex(isset($details['socket2']) ? $details['socket2'] : 255), 2, 0, STR_PAD_LEFT);
        $socket3    = str_pad(dechex(isset($details['socket3']) ? $details['socket3'] : 255), 2, 0, STR_PAD_LEFT);
        $socket4    = str_pad(dechex(isset($details['socket4']) ? $details['socket4'] : 255), 2, 0, STR_PAD_LEFT);
        $socket5    = str_pad(dechex(isset($details['socket5']) ? $details['socket5'] : 255), 2, 0, STR_PAD_LEFT);




        $hexa = (web_shopping['db_slotcount'] == 32 and web_shopping['db_version'] >= 2)
            ? strtoupper($hexaitem . $levelitem . $durability . $serial . $excelents . $ancient . $category . $item_380 . $harmony . $socket1 . $socket2 . $socket3 . $socket4 . $socket5)
            : strtoupper($hexaitem . $levelitem . $durability . $serial . $excelents . $ancient . '00');

        // var_dump($hexa);
        $account = new session();

        $acc = $this->table($table)->columns($coin)->where("{$column} = :mi", "mi={$account->useraccount}")->get();
        $p_balance = $acc->$coin;
        $c_balance = $acc->$coin - $price;

        // Gera o saldo
        $this->db()->query("INSERT INTO amw_balance_logs (account, coin_name, previous_balance, current_balance, route) VALUES ('{$account->useraccount}', '{$coin}', '{$p_balance}', '{$c_balance}', 'shopping')");

        $this->db()->query("UPDATE {$table} SET {$coin} = {$coin} - {$price} WHERE {$column} = '" . $account->useraccount . "'");

        // Gera o log do item comprado
        $this->db()->query("INSERT INTO amw_shopping_logs (shopping, account, item_name, item_category, hexa) VALUES ('{$this->info()['data']->category_group}', '{$account->useraccount}', '{$this->info()['data']->name}', '{$this->info()['data']->item_group}', '{$hexa}')");

        (new vault())->hexvault($this->infoitem->x, $this->infoitem->y, $hexa, $this->infoitem->id, $table, $column, $coin, $price);
    }

    /**
     * Get the value of idx
     */
    public function getIdx()
    {
        return $this->idx;
    }

    /**
     * Set the value of idx
     *
     * @return  self
     */
    public function setIdx($idx)
    {
        $this->idx = $idx;

        return $this;
    }
}
