<?php

namespace Amwdeveloper\plugins\ticket;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use League\Plates\Engine;

class admin extends layer
{
    private $msg;
    private $session;

    public function __construct()
    {
        global $route;
        $this->view = new Engine(__DIR__ . "/../../../theme/admin/pages", 'phtml');
        $this->route = $route;
        $this->session = new session();
        $this->msg = new message();

        if (!$this->session->has("adminlogged")) {
            return $this->route->redirect("/administration/account/login");
        }
    }

    public function checklogin()
    {
        $session = new session();
        if (!$session->has("adminlogged")) {
            return $this->route->redirect("/administration/account/login");
        }
    }


    public function open()
    {
        $tickets = $this->table("amw_tickets")->where("status = :s", "s=0")->all();
        echo $this->view->render('ticket/open', [
            'title' =>  'Tickets abertos',
            'tickets' => $tickets ?? null
        ]);
    }

    public function answered()
    {
        $tickets = $this->table("amw_tickets")->where("status = :s", "s=1")->all();
        echo $this->view->render('ticket/answered', [
            'title' =>  'Tickets respondidos',
            'tickets' => $tickets ?? null
        ]);
    }

    public function closed()
    {
        $tickets = $this->table("amw_tickets")->where("status = :s", "s=2")->all();
        echo $this->view->render('ticket/closed', [
            'title' =>  'Tickets fechados',
            'tickets' => $tickets ?? null
        ]);
    }

    public function view($id)
    {
        $slug = filter_var($id['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!$slug) return $this->route->redirect("/administration");

        $ticket_info = $this->table("amw_tickets")->where("id = :s", "s={$slug}")->get();

        if (!$ticket_info) return $this->route->redirect("/administration");

        $tickets_answered = $this->table('amw_tickets_answered')->where("id_ticket = :id", "id={$ticket_info->id}")->orderby('date')->all();

        $tickets = $this->table("amw_tickets")->where("slug = :s", "s={$slug}")->all();
        echo $this->view->render('ticket/view', [
            'title' =>  'Tickets abertos',
            'ticket_info' => $ticket_info,
            'tickets_answered' => $tickets_answered ?? null
        ]);
    }

    public function remove($id)
    {
        $slug = filter_var($id['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!$slug) return $this->route->redirect("/administration");

        $ticket_info = $this->table("amw_tickets")->where("id = :s", "s={$slug}")->get();

        if (!$ticket_info) return $this->route->redirect("/administration");

        $this->table("amw_tickets")->where("id = :id", "id={$slug}")->destroy();
        $this->table("amw_tickets_answered")->where("id_ticket = :id", "id={$slug}")->destroy();
        return $this->route->redirect("/administration");
    }

    public function finally($id)
    {
        $slug = filter_var($id['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!$slug) return $this->route->redirect("/administration/ticket/closed");

        $ticket_info = $this->table("amw_tickets")->where("id = :s", "s={$slug}")->get();

        if (!$ticket_info) return $this->route->redirect("/administration/ticket/closed");

        $this->table("amw_tickets")->where("id = :id", "id={$slug}")->updated(['status' => 2]);
        return $this->route->redirect("/administration/ticket/closed");
    }

    public function authnewtickettorespond($request)
    {
        $id_ticket = filter_var($request['id_ticket'], FILTER_VALIDATE_INT);
        $message = filter_var($request['message'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (empty($id_ticket) or empty($message)) {
            $this->msg->class('error')->text('<em><strong>Campos inválidos</strong></em>, atualize a página e tente novamente')->flash();
            return null;
        }

        if (strlen($message) < 10 or strlen($message) > 1000) {
            $this->msg->class('error')->text('Message não pode ser menor que <em><strong>10 caracteres</strong></em> ou maior que <em><strong>1000 caracteres</strong></em>')->flash();
            return null;
        }

        $ticketverifyexist = $this->table('amw_tickets')->where("id = :id", "id={$id_ticket}")->get();
        if (empty($ticketverifyexist)) {
            $this->msg->class('error')->text('Opss,<em><strong>algo deu errado</strong></em>, atualize a página e tente novamente')->flash();
            return null;
        }

        $insert = [
            'id_ticket' => $id_ticket,
            'message' => $message,
            'account' => 'suporte',
            'name' => 'Suporte',
            'date' => date('Y-m-d H:i:s', strtotime('now'))
        ];

        $this->table("amw_tickets_answered")->created($insert);
        $this->table("amw_tickets")->where("id = :id", "id={$id_ticket}")->updated(['status' => 1]);
        $this->msg->class('success')->text('<em><strong>Ticket</strong></em> respondido com sucesso!')->flash(true, true);
    }
}
