<?php

namespace Amwdeveloper\plugins\store;

use Amwdeveloper\core\session;
use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use Amwdeveloper\plugins\webshop\vault;

class item extends layer
{

    protected function loadvault()
    {
        $session = (new session())->useraccount;
        $vault = $this->table("warehouse")->columns("Items")->where("AccountID = :acc", "acc={$session}")->get();
        return strtoupper(bin2hex($vault->Items));
    }

    public function infokit($items)
    {

        $listitem = array();
        foreach ($items as $item_details) {

            $itemverify = $this->table("amw_items")
                ->where("section = :s AND id_item = :id", "s={$item_details['section']}&id={$item_details['index']}")
                ->get();
            if (empty($itemverify)) return null;

            if (web_shopping['db_version'] == 1) {
                $item_convert = $itemverify->id_item + ($itemverify->section  * 32);
                $item = (int)($item_convert % 256);
                $group = (int)($item_convert / 256);

                if ($group == 1) $this->excelents = 128;
            } else {
                $item = $itemverify->id_item;
            }

            $serial = str_pad(dechex(substr(rand(0, 9999999999), 0, 8)), 8, 0, STR_PAD_LEFT);

            $listitem[] = array(
                'item' => $item,
                'group' => $group ?? null,
                'serial' => $serial,
                'luck' => 1,
                'skill' => 1,
                'section' => $item_details['section'],
                'ancient' => $item_details['anc'],
                'aditional' => $item_details['opt'],
                'level' => $item_details['level'],
                'excelent' => $item_details['exc'],
                'socket1' => $item_details['skt1'],
                'socket2' => $item_details['skt2'],
                'socket3' => $item_details['skt3'],
                'socket4' => $item_details['skt4'],
                'socket5' => $item_details['skt5'],
                'harmony' => $item_details['harmony'],
                'id_items' => $itemverify->id,
                'x' => $itemverify->x,
                'y' => $itemverify->y

            );
        }
        return $listitem ?? null;
    }

    public function addItemAccount($list_item)
    {
        if ($this->infokit($list_item)) {
            $session = new session();
            $messages = new message();

            foreach ($this->infokit($list_item) as $item) {
                $this->excelents = 0;
                $this->ancient = 0;

                if (isset($item['group']) and $item['group'] == 1) $this->excelents = 128;
                $category = dechex($item['section']);

                $levelitem = $item['level'] * 8;

                /** [Validando os Adicionais dos itens e somando ao level do item] */
                if ($item['aditional'] == 4 or $item['aditional']  == 20) $levelitem += 1;
                if ($item['aditional'] == 8 or $item['aditional']  == 24) $levelitem += 2;
                if ($item['aditional'] == 12 or $item['aditional'] == 28) $levelitem += 3;


                /** [Se o Adicionar for >= 16 então o excelentes recebe + 64] */
                if ($item['aditional'] >= 16) $this->excelents += 64;

                /** [Se existe Luck level recebe + 4 | se existe skill level recebe + 128] */
                if ($item['luck']  == 1) $levelitem += 4;
                if ($item['skill'] == 1) $levelitem += 128;

                /** [Validando os excelentes do item] */
                if ($item['excelent'] >= 1) $this->excelents +=  1;
                if ($item['excelent'] >= 2) $this->excelents +=  2;
                if ($item['excelent'] >= 3) $this->excelents +=  4;
                if ($item['excelent'] >= 4) $this->excelents +=  8;
                if ($item['excelent'] >= 5) $this->excelents += 16;
                if ($item['excelent'] >= 6) $this->excelents += 32;

                if ($item['item'] >= 256 and $item['section'] > 13) $this->excelents = 128;
                if ($item['item'] >= 256 and $item['section'] <= 12) $this->excelents = 255;

                /** [Ancients do item] */
                if ($item['ancient'] == 1) $this->ancient = 5;
                elseif ($item['ancient'] == 2) $this->ancient = 10;
                else $this->ancient = 0;

                $hexaitem = ($item['item'] >= 256)
                    ? substr(dechex($item['item'] + 256), 1, 2)
                    : str_pad(dechex($item['item']), 2, 0, STR_PAD_LEFT);


                $durability = str_pad(dechex(255), 2, 0, STR_PAD_LEFT);

                $excelents  = str_pad(dechex($this->excelents), 2, 0, STR_PAD_LEFT);

                $levelitem  = str_pad(dechex($levelitem), 2, 0, STR_PAD_LEFT);

                $ancient    = str_pad(dechex($this->ancient), 2, 0, STR_PAD_LEFT);

                $harmony = str_pad(dechex($item['harmony']), 2, 0, STR_PAD_LEFT);

                $socket1    = str_pad(dechex($item['socket1']), 2, 0, STR_PAD_LEFT);
                $socket2    = str_pad(dechex($item['socket2']), 2, 0, STR_PAD_LEFT);
                $socket3    = str_pad(dechex($item['socket3']), 2, 0, STR_PAD_LEFT);
                $socket4    = str_pad(dechex($item['socket4']), 2, 0, STR_PAD_LEFT);
                $socket5    = str_pad(dechex($item['socket5']), 2, 0, STR_PAD_LEFT);

                $hexa = (web_shopping['db_slotcount'] == 32 and web_shopping['db_version'] >= 2)
                    ? strtoupper($hexaitem . $levelitem . $durability . $item['serial'] . $excelents . $ancient . $category . '0' . $harmony . $socket1 . $socket2 . $socket3 . $socket4 . $socket5)
                    : strtoupper($hexaitem . $levelitem . $durability . $item['serial'] . $excelents . '00' . $ancient);

                (new vault())->hexvaultkit($item['x'], $item['y'], $hexa, $item['id_items']);
            }
        }
    }

    public function addVipAccount($details)
    {
        $session = (new session())->useraccount;
        $account = $this->table("MEMB_INFO")->columns("AccountExpireDate as expire, " . config['column_vip'] . " as vip")->where("memb___id = :mi", "mi={$session}")->get();
        if ($account->vip == 0 or $account->expire < date('Y-m-d H:i:s')) {
            $update = array(config['column_vip']  => $details['type'], 'AccountExpireDate' =>  date('Y-m-d H:i:s', strtotime("+{$details['time']} days")));
        } else {
            $update = array('AccountExpireDate' => date('Y-m-d H:i:s', strtotime("+{$details['time']} days", strtotime($account->expire))));
        }
        $this->table("MEMB_INFO")->where("memb___id = :mi", "mi={$session}")->updated($update);
    }

    public function addCoinAccount($details)
    {
        $session = (new session())->useraccount;
        $account = $this->table("" . $details['table'] . "")->columns("" . $details['column_coin'] . " as coin")->where("" . $details['column_account'] . " = :mi", "mi={$session}")->get();
        $update = array($details['column_coin'] => ($account->coin + $details['quantity']));
        $this->table("" . $details['table'] . "")->where("" . $details['column_account'] . " = :mi", "mi={$session}")->updated($update);
    }
}
