<?php

namespace Amwdeveloper\plugins\posts;

use Amwdeveloper\model\layer;
use Amwdeveloper\model\message;
use Cocur\Slugify\Slugify;

class admin extends layer
{
    public $message;
    public function __construct()
    {
        $this->message = new message();
    }
    public function newnotice($request)
    {
        $title = filter_var($request['title'], FILTER_SANITIZE_SPECIAL_CHARS);
        $description = filter_var($request['description'], FILTER_SANITIZE_SPECIAL_CHARS);
        $category = filter_var($request['category'], FILTER_SANITIZE_SPECIAL_CHARS);
        $link = filter_var($request['link'], FILTER_SANITIZE_SPECIAL_CHARS);
        $comment = $request['comment'];
        $message = $request['message'];

        if (empty($title) or empty($description) or empty($category) or empty($message)) {
            $this->message->class("error")->text("Preecha os <em><strong>campos</strong></em> corretamente")->flash();
            return null;
        }

        $verifytitle = $this->table("amw_notice")->where("title = :title", "title={$title}")->get();

        if (!empty($verifytitle)) {
            $this->message->class("error")->text("<em><strong>Título da notícia</strong></em> já está sendo usado")->flash();
            return null;
        }

        $insert = [
            'title' => $title,
            'description' => $description,
            'link' => $link ?? NULL,
            'comment' => $comment,
            'message' => trim($message),
            'tag' => $category,
            'date' => date('Y-m-d H:i:s', strtotime("now")),
            'account' => 'Administrador',
            'slug' => (new Slugify())->slugify($title)
        ];

        $this->table("amw_notice")->created($insert);

        $this->message->class("success")->text("<em><strong>Notícia</strong></em> adicionada com sucesso")->flash(true, true);
    }

    public function updatenotice($request)
    {
        $id = filter_var($request['id'], FILTER_VALIDATE_INT);
        $title = filter_var($request['title'], FILTER_SANITIZE_SPECIAL_CHARS);
        $description = filter_var($request['description'], FILTER_SANITIZE_SPECIAL_CHARS);
        $category = filter_var($request['category'], FILTER_SANITIZE_SPECIAL_CHARS);
        $link = filter_var($request['link'], FILTER_SANITIZE_SPECIAL_CHARS);
        $comment = $request['comment'];
        $message = $request['message'];

        if (empty($title) or empty($description) or empty($category) or empty($message) or empty($id)) {
            $this->message->class("error")->text("Preecha os <em><strong>campos</strong></em> corretamente")->flash();
            return null;
        }

        $verifytitle = $this->table("amw_notice")->where("title = :title AND id != :id", "title={$title}&id={$id}")->get();

        if (!empty($verifytitle)) {
            $this->message->class("error")->text("<em><strong>Título da notícia</strong></em> já está sendo usado")->flash();
            return null;
        }

        $update = [
            'title' => $title,
            'description' => $description,
            'link' => $link ?? NULL,
            'comment' => $comment,
            'message' => trim($message),
            'tag' => $category,
            'slug' => (new Slugify())->slugify($title)
        ];

        $this->table("amw_notice")->where("id = :id", "id={$id}")->updated($update);

        $this->message->class("success")->text("<em><strong>Notícia</strong></em> editada com sucesso")->flash(false, true);
    }

    public function removenotice($request)
    {
        global $route;
        $id = filter_var($request['id'], FILTER_VALIDATE_INT);

        if (empty($id)) $route->redirect("/administration/manage/all/posts");

        $verifytitle = $this->table("amw_notice")->where("id = :id", "id={$id}")->get();

        if (empty($verifytitle)) $route->redirect("/administration/manage/all/posts");

        $this->table("amw_notice")->where("id = :id", "id={$id}")->destroy();

        $route->redirect("/administration/manage/all/posts");
    }
}
