<?php

namespace Amwdeveloper\plugins\hallfame;

use Amwdeveloper\model\layer;

class geral extends layer
{
    public function verifyrankingexist(array $ranking)
    {
        global $route;
        $slug = filter_var($ranking['gerate'], FILTER_SANITIZE_SPECIAL_CHARS);
        $slugs = array();
        foreach (ranking_geral['rankings'] as $verify) $slugs[] = $verify['slug'];
        if (!in_array($slug, $slugs)) $route->redirect("/rankings");
    }

    public function render(array $ranking)
    {
        $slug = filter_var($ranking['gerate'], FILTER_SANITIZE_SPECIAL_CHARS);
        $ranking = array();
        foreach (ranking_geral['rankings'] as $verify) if ($verify['slug'] == $slug) $ranking[] = $verify;

        $info = $ranking[0];
        $top = ranking_geral['tops'];
        $returnranking = array();
        $type = '';

        if ($info['table'] == 'Character') {
            $type = "char";
            $ranking = $this->limit($top)->columns("c.Name as name, {$info['column']} as score, cLevel as level, c.Class as class, c.Imagem as image, gm.G_Name as gname, ms.ConnectStat as status,acc.GameIDC as gameidc")
                ->inner("Character c 
                LEFT JOIN GuildMember gm ON gm.Name = c.Name 
                LEFT JOIN MEMB_STAT ms ON ms.memb___id = c.AccountID 
                LEFT JOIN AccountCharacter acc ON acc.Id = c.AccountID")
                ->orderby($info['column'])->all();
        }
        if ($info['table'] != 'Guild' && $info['table'] != 'Character') {
            $type = "char";
            $ranking = $this->limit($top)->columns("r.Name as name, r.{$info['column']} as score, c.cLevel as level,c.Class as class, c.Imagem as image, gm.G_Name as gname,ms.ConnectStat as status,acc.GameIDC as gameidc ")
                ->inner("{$info['table']} r LEFT JOIN Character c ON c.Name = r.Name 
                LEFT JOIN GuildMember gm ON gm.Name = r.Name 
                LEFT JOIN MEMB_STAT ms ON ms.memb___id = c.AccountID
                LEFT JOIN AccountCharacter acc ON acc.Id = ms.memb___id")
                ->where("CtlCode =:ct", "ct=0")
                ->orderby($info['column'])
                ->all();
        }
        if ($info['table'] == 'Guild') {
            $type = "guild";
            $ranking = $this->limit($top)->table($info['table'])->columns("G_Name as gname, G_Mark as mark, G_Master as master, {$info['column']} as score")
                ->orderby($info['column'])
                ->all();
        }

        foreach ($ranking as $rank) {
            if ($info['table'] != 'Guild') {
                $returnranking[] = [
                    'name' => $rank->name,
                    'guild' => $rank->gname ?? '-',
                    'score' => $rank->score,
                    'image' => $rank->image,
                    'level' => $rank->level,
                    'class' => $rank->class,
                    'status' => ($rank->status == 0 or $rank->name != $rank->gameidc) ? 'offline' : 'online'
                ];
            } else {
                $members = $this->table("GuildMember")->where("G_Name = :gname", "gname={$rank->gname}")->count();
                $returnranking[] = [
                    'gname' => $rank->gname,
                    'master' => $rank->master,
                    'members' => $members->amount,
                    'mark' => $rank->mark,
                    'score' => $rank->score
                ];
            }
        }

        return ['title' => $info['title'], 'tag_name' => $info['tag_name'], 'type' => $type, 'ranking' => $returnranking];
    }
}
